<?php
header('Content-Type: application/json');

// Connect to the SQLite database
try {
    $db = new SQLite3('ygroups.db3');
} catch (Exception $e) {
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents("php://input"), true);
$messageNumber = $input['message_number'] ?? null;

if (!$messageNumber) {
    echo json_encode(['error' => 'Message number is required']);
    exit;
}

// Fetch group message details
$stmt = $db->prepare('SELECT * FROM group_message WHERE number = :message_number');
$stmt->bindValue(':message_number', $messageNumber, SQLITE3_INTEGER);
$result = $stmt->execute();

$message = $result->fetchArray(SQLITE3_ASSOC);

if ($message) {
    echo json_encode([
        'success' => true,
        'data' => [
            'number' => $message['number'],
            'subject' => $message['subject'],
            'date' => $message['date'],
            'content' => $message['content'],
            'author' => $message['author'] ?? 'Unknown'
        ]
    ]);
} else {
    echo json_encode([
        'success' => false,
        'error' => 'Message #' . $messageNumber . ' not found'
    ]);
}

$db->close();
?>