<?php
// generate_token.php
$tokensFile = __DIR__ . "/tokens.json";

// Load existing tokens
$tokens = file_exists($tokensFile) ? json_decode(file_get_contents($tokensFile), true) : [];

// Create random token
$newToken = bin2hex(random_bytes(8)); // e.g. "a3f1b9c8d4e5f6a7"

// Expiry (24 hours from now)
$expiry = date("Y-m-d H:i:s", time() + 86400);

$tokens[$newToken] = [
    "expires" => $expiry,
    "used" => false
];

// Save back
file_put_contents($tokensFile, json_encode($tokens, JSON_PRETTY_PRINT | LOCK_EX));

echo "New token: $newToken (expires: $expiry)\n";
